<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$stmt = $pdo->query("
SELECT w.*, p.project_name
FROM project_works w
JOIN projects p ON w.project_id = p.id
ORDER BY w.id DESC
");
$works = $stmt->fetchAll();
?>

<h4 class="mb-3">All Works</h4>

<div class="row">
<?php foreach ($works as $w): ?>
    <div class="col-md-4 col-12 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6><?= $w['work_title'] ?></h6>
                <small>Project: <?= $p = $w['project_name'] ?></small><br>
                <small>Status: <b><?= $w['status'] ?></b></small><br><br>

                <a href="works.php?project_id=<?= $w['project_id'] ?>" class="btn btn-sm btn-primary">
                    View Project Works
                </a>
            </div>
        </div>
    </div>
<?php endforeach; ?>
</div>

<?php include "app/views/footer.php"; ?>
