<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$project_id = $_GET['project_id'] ?? null;
if (!$project_id) {
    echo "Project not selected";
    exit;
}

// Fetch project
$stmt = $pdo->prepare("SELECT * FROM projects WHERE id=?");
$stmt->execute([$project_id]);
$project = $stmt->fetch();
if (!$project) {
    echo "Project not found";
    exit;
}

// Fetch works
$stmt = $pdo->prepare(
    "SELECT * FROM project_works WHERE project_id=? ORDER BY id DESC"
);
$stmt->execute([$project_id]);
$works = $stmt->fetchAll();
?>

<h4 class="mb-2">Works – <?= htmlspecialchars($project['project_name']) ?></h4>

<a href="work_add.php?project_id=<?= $project_id ?>" class="btn btn-primary btn-sm mb-3">
    + Add Work
</a>

<?php if (!$works): ?>
    <p>No work/tasks added yet.</p>
<?php endif; ?>

<div class="row">
<?php foreach ($works as $w): ?>
    <div class="col-md-4 col-12 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6><?= htmlspecialchars($w['work_title']) ?></h6>
                <small><?= nl2br(htmlspecialchars($w['description'])) ?></small><br><br>

                <small>
                    Status:
                    <b><?= $w['status'] ?></b>
                </small><br>

                <small>
                    📅 <?= $w['start_date'] ?> → <?= $w['end_date'] ?>
                </small><br><br>

                <a href="work_edit.php?id=<?= $w['id'] ?>&project_id=<?= $project_id ?>"
                   class="btn btn-sm btn-warning">Edit</a>

                <a href="work_delete.php?id=<?= $w['id'] ?>&project_id=<?= $project_id ?>"
                   class="btn btn-sm btn-danger"
                   onclick="return confirm('Delete this work?')">
                   Delete
                </a>
            </div>
        </div>
    </div>
<?php endforeach; ?>
</div>

<?php include "app/views/footer.php"; ?>
