<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$id = $_GET['id'];
$project_id = $_GET['project_id'];

$stmt = $pdo->prepare("SELECT * FROM project_works WHERE id=?");
$stmt->execute([$id]);
$work = $stmt->fetch();

if (!$work) {
    echo "Work not found";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare(
        "UPDATE project_works SET
        work_title=?, description=?, status=?, start_date=?, end_date=?
        WHERE id=?"
    );

    $stmt->execute([
        $_POST['work_title'],
        $_POST['description'],
        $_POST['status'],
        $_POST['start_date'],
        $_POST['end_date'],
        $id
    ]);

    header("Location: works.php?project_id=".$project_id);
    exit;
}
?>

<h4 class="mb-3">Edit Work</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="work_title" value="<?= $work['work_title'] ?>" required>

    <textarea class="form-control mb-2" name="description"><?= $work['description'] ?></textarea>

    <select class="form-control mb-2" name="status">
        <?php
        $statuses = ['Pending','In Progress','Completed'];
        foreach ($statuses as $s) {
            $selected = ($work['status'] === $s) ? 'selected' : '';
            echo "<option $selected>$s</option>";
        }
        ?>
    </select>

    <input class="form-control mb-2" type="date" name="start_date" value="<?= $work['start_date'] ?>">
    <input class="form-control mb-2" type="date" name="end_date" value="<?= $work['end_date'] ?>">

    <button class="btn btn-primary">Update Work</button>
</form>

<?php include "app/views/footer.php"; ?>
