<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$project_id = $_GET['project_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare(
        "INSERT INTO project_works
        (project_id, work_title, description, status, start_date, end_date)
        VALUES (?, ?, ?, ?, ?, ?)"
    );

    $stmt->execute([
        $project_id,
        $_POST['work_title'],
        $_POST['description'],
        $_POST['status'],
        $_POST['start_date'],
        $_POST['end_date']
    ]);

    header("Location: works.php?project_id=".$project_id);
    exit;
}
?>

<h4 class="mb-3">Add Work</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="work_title" placeholder="Work Title" required>

    <textarea class="form-control mb-2" name="description" placeholder="Description"></textarea>

    <select class="form-control mb-2" name="status">
        <option>Pending</option>
        <option>In Progress</option>
        <option>Completed</option>
    </select>

    <input class="form-control mb-2" type="date" name="start_date">
    <input class="form-control mb-2" type="date" name="end_date">

    <button class="btn btn-success">Save Work</button>
</form>

<?php include "app/views/footer.php"; ?>
