<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$stmt = $pdo->query("
SELECT p.*, c.name AS client_name
FROM projects p
JOIN clients c ON p.client_id = c.id
ORDER BY p.id DESC
");
$projects = $stmt->fetchAll();
?>

<h4 class="mb-3">All Projects</h4>

<div class="row">
<?php foreach ($projects as $p): ?>
    <div class="col-md-4 col-12 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6><?= $p['project_name'] ?></h6>
                <small>Client: <?= $p['client_name'] ?></small><br>
                <small>Status: <b><?= $p['status'] ?></b></small><br><br>

                <a href="projects.php?client_id=<?= $p['client_id'] ?>" class="btn btn-sm btn-info">
                    View Client Projects
                </a>
                <a href="works.php?project_id=<?= $p['id'] ?>" class="btn btn-sm btn-secondary">
                    Works
                </a>
            </div>
        </div>
    </div>
<?php endforeach; ?>
</div>

<?php include "app/views/footer.php"; ?>
