<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$client_id = $_GET['client_id'] ?? null;
if (!$client_id) {
    echo "Client not selected";
    exit;
}

// Fetch client
$stmt = $pdo->prepare("SELECT * FROM clients WHERE id=?");
$stmt->execute([$client_id]);
$client = $stmt->fetch();
if (!$client) {
    echo "Client not found";
    exit;
}

// Fetch projects
$stmt = $pdo->prepare(
    "SELECT * FROM projects WHERE client_id=? ORDER BY id DESC"
);
$stmt->execute([$client_id]);
$projects = $stmt->fetchAll();
?>

<h4 class="mb-2">Projects – <?= htmlspecialchars($client['name']) ?></h4>

<a href="project_add.php?client_id=<?= $client_id ?>" class="btn btn-primary btn-sm mb-3">
    + Add Project
</a>

<?php if (!$projects): ?>
    <p>No projects found.</p>
<?php endif; ?>

<div class="row">
<?php foreach ($projects as $p): ?>
    <div class="col-md-4 col-12 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6><?= htmlspecialchars($p['project_name']) ?></h6>
                <small>📍 <?= $p['location'] ?></small><br>
                <small>📅 <?= $p['start_date'] ?> → <?= $p['expected_end_date'] ?></small><br>
                <small>
                    Status:
                    <b><?= $p['status'] ?></b>
                </small><br><br>
                <a href="materials.php?project_id=<?= $p['id'] ?>" class="btn btn-sm btn-dark">
    Materials
</a>

                <a href="works.php?project_id=<?= $p['id'] ?>" class="btn btn-sm btn-secondary">
    Works
</a>
<a href="invoices.php?project_id=<?= $p['id'] ?>" class="btn btn-sm btn-success">
    Invoice
</a>

<a href="labour.php?project_id=<?= $p['id'] ?>" class="btn btn-sm btn-warning">
    Labours
</a>

                <a href="project_edit.php?id=<?= $p['id'] ?>&client_id=<?= $client_id ?>"
                   class="btn btn-sm btn-warning">Edit</a>

                <a href="project_delete.php?id=<?= $p['id'] ?>&client_id=<?= $client_id ?>"
                   class="btn btn-sm btn-danger"
                   onclick="return confirm('Delete this project?')">
                   Delete
                </a>
            </div>
        </div>
    </div>
<?php endforeach; ?>
</div>

<?php include "app/views/footer.php"; ?>
