<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$id = $_GET['id'];
$client_id = $_GET['client_id'];

$stmt = $pdo->prepare("SELECT * FROM projects WHERE id=?");
$stmt->execute([$id]);
$project = $stmt->fetch();

if (!$project) {
    echo "Project not found";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare(
        "UPDATE projects SET
        project_name=?, location=?, start_date=?, expected_end_date=?, total_value=?, status=?
        WHERE id=?"
    );

    $stmt->execute([
        $_POST['project_name'],
        $_POST['location'],
        $_POST['start_date'],
        $_POST['expected_end_date'],
        $_POST['total_value'],
        $_POST['status'],
        $id
    ]);

    header("Location: projects.php?client_id=".$client_id);
    exit;
}
?>

<h4 class="mb-3">Edit Project</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="project_name" value="<?= $project['project_name'] ?>" required>
    <input class="form-control mb-2" name="location" value="<?= $project['location'] ?>">
    <input class="form-control mb-2" type="date" name="start_date" value="<?= $project['start_date'] ?>">
    <input class="form-control mb-2" type="date" name="expected_end_date" value="<?= $project['expected_end_date'] ?>">
    <input class="form-control mb-2" name="total_value" value="<?= $project['total_value'] ?>">

    <select class="form-control mb-3" name="status">
        <?php
        $statuses = ['Not Started','In Progress','On Hold','Completed'];
        foreach ($statuses as $s) {
            $selected = ($project['status'] === $s) ? 'selected' : '';
            echo "<option $selected>$s</option>";
        }
        ?>
    </select>

    <button class="btn btn-primary">Update Project</button>
</form>

<?php include "app/views/footer.php"; ?>
