<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$client_id = $_GET['client_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare(
        "INSERT INTO projects
        (client_id, project_name, location, start_date, expected_end_date, total_value, status)
        VALUES (?, ?, ?, ?, ?, ?, ?)"
    );

    $stmt->execute([
        $client_id,
        $_POST['project_name'],
        $_POST['location'],
        $_POST['start_date'],
        $_POST['expected_end_date'],
        $_POST['total_value'],
        $_POST['status']
    ]);

    header("Location: projects.php?client_id=".$client_id);
    exit;
}
?>

<h4 class="mb-3">Add Project</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="project_name" placeholder="Project Name" required>
    <input class="form-control mb-2" name="location" placeholder="Location">
    <input class="form-control mb-2" type="date" name="start_date">
    <input class="form-control mb-2" type="date" name="expected_end_date">
    <input class="form-control mb-2" name="total_value" placeholder="Total Project Value">

    <select class="form-control mb-3" name="status">
        <option>Not Started</option>
        <option>In Progress</option>
        <option>On Hold</option>
        <option>Completed</option>
    </select>

    <button class="btn btn-success">Save Project</button>
</form>

<?php include "app/views/footer.php"; ?>
