<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$stmt = $pdo->query("
SELECT m.*, p.project_name
FROM materials m
JOIN projects p ON m.project_id = p.id
ORDER BY m.id DESC
");
$materials = $stmt->fetchAll();
?>

<h4 class="mb-3">All Materials</h4>

<table class="table table-bordered table-sm">
<tr>
    <th>Material</th>
    <th>Project</th>
    <th>Cost</th>
</tr>
<?php foreach ($materials as $m): ?>
<tr>
    <td><?= $m['material_name'] ?></td>
    <td><?= $m['project_name'] ?></td>
    <td>₹<?= number_format($m['cost'],2) ?></td>
</tr>
<?php endforeach; ?>
</table>

<?php include "app/views/footer.php"; ?>
