<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$project_id = $_GET['project_id'] ?? null;
if (!$project_id) {
    echo "Project not selected";
    exit;
}

// Fetch project
$stmt = $pdo->prepare("SELECT project_name FROM projects WHERE id=?");
$stmt->execute([$project_id]);
$project = $stmt->fetch();
if (!$project) {
    echo "Project not found";
    exit;
}

// Fetch materials
$stmt = $pdo->prepare("SELECT * FROM materials WHERE project_id=? ORDER BY id DESC");
$stmt->execute([$project_id]);
$materials = $stmt->fetchAll();

// Total cost
$stmt = $pdo->prepare("SELECT SUM(cost) as total FROM materials WHERE project_id=?");
$stmt->execute([$project_id]);
$totalCost = $stmt->fetch()['total'] ?? 0;
?>

<h4 class="mb-2">Materials – <?= htmlspecialchars($project['project_name']) ?></h4>

<div class="mb-3">
    <strong>Total Material Cost:</strong> ₹<?= number_format($totalCost, 2) ?>
</div>

<a href="material_add.php?project_id=<?= $project_id ?>" class="btn btn-primary btn-sm mb-3">
    + Add Material
</a>

<?php if (!$materials): ?>
    <p>No materials added yet.</p>
<?php endif; ?>

<div class="row">
<?php foreach ($materials as $m): ?>
    <div class="col-md-4 col-12 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6><?= htmlspecialchars($m['material_name']) ?></h6>
                <small>Qty: <?= $m['quantity'] ?></small><br>
                <small>Supplier: <?= $m['supplier_name'] ?></small><br>
                <small>Date: <?= $m['purchase_date'] ?></small><br>
                <strong>₹<?= number_format($m['cost'], 2) ?></strong><br><br>

                <a href="material_edit.php?id=<?= $m['id'] ?>&project_id=<?= $project_id ?>"
                   class="btn btn-sm btn-warning">Edit</a>

                <a href="material_delete.php?id=<?= $m['id'] ?>&project_id=<?= $project_id ?>"
                   class="btn btn-sm btn-danger"
                   onclick="return confirm('Delete this material?')">
                   Delete
                </a>
            </div>
        </div>
    </div>
<?php endforeach; ?>
</div>

<?php include "app/views/footer.php"; ?>
