<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$id = $_GET['id'];
$project_id = $_GET['project_id'];

$stmt = $pdo->prepare("SELECT * FROM materials WHERE id=?");
$stmt->execute([$id]);
$material = $stmt->fetch();

if (!$material) {
    echo "Material not found";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare(
        "UPDATE materials SET
        material_name=?, quantity=?, supplier_name=?, purchase_date=?, cost=?
        WHERE id=?"
    );

    $stmt->execute([
        $_POST['material_name'],
        $_POST['quantity'],
        $_POST['supplier_name'],
        $_POST['purchase_date'],
        $_POST['cost'],
        $id
    ]);

    header("Location: materials.php?project_id=".$project_id);
    exit;
}
?>

<h4 class="mb-3">Edit Material</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="material_name" value="<?= $material['material_name'] ?>" required>
    <input class="form-control mb-2" name="quantity" value="<?= $material['quantity'] ?>">
    <input class="form-control mb-2" name="supplier_name" value="<?= $material['supplier_name'] ?>">
    <input class="form-control mb-2" type="date" name="purchase_date" value="<?= $material['purchase_date'] ?>">
    <input class="form-control mb-2" name="cost" value="<?= $material['cost'] ?>" required>

    <button class="btn btn-primary">Update Material</button>
</form>

<?php include "app/views/footer.php"; ?>
