<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$project_id = $_GET['project_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare(
        "INSERT INTO materials
        (project_id, material_name, quantity, supplier_name, purchase_date, cost)
        VALUES (?, ?, ?, ?, ?, ?)"
    );

    $stmt->execute([
        $project_id,
        $_POST['material_name'],
        $_POST['quantity'],
        $_POST['supplier_name'],
        $_POST['purchase_date'],
        $_POST['cost']
    ]);

    header("Location: materials.php?project_id=".$project_id);
    exit;
}
?>

<h4 class="mb-3">Add Material</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="material_name" placeholder="Material Name" required>
    <input class="form-control mb-2" name="quantity" placeholder="Quantity (e.g. 10 bags)">
    <input class="form-control mb-2" name="supplier_name" placeholder="Supplier Name">
    <input class="form-control mb-2" type="date" name="purchase_date">
    <input class="form-control mb-2" name="cost" placeholder="Cost" required>

    <button class="btn btn-success">Save Material</button>
</form>

<?php include "app/views/footer.php"; ?>
