<?php
session_start();
require_once "app/config/db.php";

if (isset($_SESSION['admin_id'])) {
    header("Location: dashboard.php");
    exit;
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM admins WHERE email = ?");
    $stmt->execute([$email]);
    $admin = $stmt->fetch();

    if ($admin) {
        $_SESSION['admin_id'] = $admin['id'];
        $_SESSION['admin_name'] = $admin['name'];
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Invalid email or password";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Admin Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
* {
    box-sizing: border-box;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
}

body {
    margin: 0;
    height: 100vh;
    background: linear-gradient(135deg, #0d6efd, #6610f2);
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Card */
.login-card {
    background: #fff;
    width: 100%;
    max-width: 380px;
    padding: 30px;
    border-radius: 16px;
    box-shadow: 0 20px 50px rgba(0,0,0,0.25);
    animation: fadeUp 0.6s ease;
}

/* Animation */
@keyframes fadeUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Header */
.login-card h2 {
    margin: 0 0 6px;
    text-align: center;
    font-weight: 700;
    color: #333;
}

.login-card p {
    text-align: center;
    margin-bottom: 25px;
    font-size: 14px;
    color: #777;
}

/* Inputs */
.form-group {
    margin-bottom: 16px;
}

.form-group input {
    width: 100%;
    padding: 14px 14px;
    border-radius: 10px;
    border: 1px solid #ddd;
    font-size: 15px;
    outline: none;
    transition: all 0.2s ease;
}

.form-group input:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 3px rgba(13,110,253,0.15);
}

/* Button */
.login-btn {
    width: 100%;
    padding: 14px;
    border-radius: 12px;
    border: none;
    background: linear-gradient(135deg, #0d6efd, #6610f2);
    color: #fff;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: transform 0.15s ease, box-shadow 0.15s ease;
}

.login-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.25);
}

/* Error */
.error {
    background: #ffe1e1;
    color: #b30000;
    padding: 10px;
    border-radius: 8px;
    font-size: 14px;
    margin-bottom: 15px;
    text-align: center;
}

/* Footer */
.login-footer {
    margin-top: 18px;
    text-align: center;
    font-size: 12px;
    color: #999;
}
</style>
</head>

<body>

<div class="login-card">
    <h2>Welcome Back</h2>
    <p>Sign in to continue</p>

    <?php if ($error): ?>
        <div class="error"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="form-group">
            <input type="email" name="email" placeholder="Email address" required>
        </div>

        <div class="form-group">
            <input type="password" name="password" placeholder="Password" required>
        </div>

        <button class="login-btn">Login</button>
    </form>

    <div class="login-footer">
        © <?= date('Y') ?> Real Estate Admin
    </div>
</div>

</body>
</html>
