<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$id = $_GET['id'];
$project_id = $_GET['project_id'];

$stmt = $pdo->prepare("SELECT * FROM labour WHERE id=?");
$stmt->execute([$id]);
$l = $stmt->fetch();

if (!$l) {
    echo "Labour not found";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $rate = $_POST['rate'];
    $days = $_POST['working_days'];
    $charge_type = $_POST['charge_type'];
    $total = ($charge_type === 'Daily') ? ($rate * $days) : $rate;

    $stmt = $pdo->prepare(
        "UPDATE labour SET
        labour_name=?, work_type=?, charge_type=?, rate=?, working_days=?, total_amount=?
        WHERE id=?"
    );

    $stmt->execute([
        $_POST['labour_name'],
        $_POST['work_type'],
        $charge_type,
        $rate,
        $days,
        $total,
        $id
    ]);

    header("Location: labour.php?project_id=".$project_id);
    exit;
}
?>

<h4 class="mb-3">Edit Labour</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="labour_name" value="<?= $l['labour_name'] ?>" required>
    <input class="form-control mb-2" name="work_type" value="<?= $l['work_type'] ?>">

    <select class="form-control mb-2" name="charge_type">
        <option value="Daily" <?= $l['charge_type']=='Daily'?'selected':'' ?>>Daily</option>
        <option value="Fixed" <?= $l['charge_type']=='Fixed'?'selected':'' ?>>Fixed</option>
    </select>

    <input class="form-control mb-2" name="rate" value="<?= $l['rate'] ?>" required>
    <input class="form-control mb-2" name="working_days" value="<?= $l['working_days'] ?>">

    <button class="btn btn-primary">Update Labour</button>
</form>

<?php include "app/views/footer.php"; ?>
