<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$stmt = $pdo->query("
SELECT l.*, p.project_name
FROM labour l
JOIN projects p ON l.project_id = p.id
ORDER BY l.id DESC
");
$labours = $stmt->fetchAll();
?>

<h4 class="mb-3">All Labour</h4>

<table class="table table-bordered table-sm">
<tr>
    <th>Name</th>
    <th>Project</th>
    <th>Total</th>
</tr>
<?php foreach ($labours as $l): ?>
<tr>
    <td><?= $l['labour_name'] ?></td>
    <td><?= $l['project_name'] ?></td>
    <td>₹<?= number_format($l['total_amount'],2) ?></td>
</tr>
<?php endforeach; ?>
</table>

<?php include "app/views/footer.php"; ?>
