<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$project_id = $_GET['project_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $rate = $_POST['rate'];
    $days = $_POST['working_days'];
    $charge_type = $_POST['charge_type'];

    $total = ($charge_type === 'Daily') ? ($rate * $days) : $rate;

    $stmt = $pdo->prepare(
        "INSERT INTO labour
        (project_id, labour_name, work_type, charge_type, rate, working_days, total_amount)
        VALUES (?, ?, ?, ?, ?, ?, ?)"
    );

    $stmt->execute([
        $project_id,
        $_POST['labour_name'],
        $_POST['work_type'],
        $charge_type,
        $rate,
        $days,
        $total
    ]);

    header("Location: labour.php?project_id=".$project_id);
    exit;
}
?>

<h4 class="mb-3">Add Labour</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="labour_name" placeholder="Labour / Contractor Name" required>
    <input class="form-control mb-2" name="work_type" placeholder="Type of Work">

    <select class="form-control mb-2" name="charge_type">
        <option value="Daily">Daily</option>
        <option value="Fixed">Fixed</option>
    </select>

    <input class="form-control mb-2" name="rate" placeholder="Rate" required>
    <input class="form-control mb-2" name="working_days" placeholder="Working Days (0 for fixed)">

    <button class="btn btn-success">Save Labour</button>
</form>

<?php include "app/views/footer.php"; ?>
