<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$project_id = $_GET['project_id'] ?? null;
if (!$project_id) {
    echo "Project not selected";
    exit;
}

// Fetch project
$stmt = $pdo->prepare("SELECT project_name FROM projects WHERE id=?");
$stmt->execute([$project_id]);
$project = $stmt->fetch();

// Fetch labour
$stmt = $pdo->prepare("SELECT * FROM labour WHERE project_id=? ORDER BY id DESC");
$stmt->execute([$project_id]);
$labours = $stmt->fetchAll();

// Total labour cost
$stmt = $pdo->prepare("SELECT SUM(total_amount) as total FROM labour WHERE project_id=?");
$stmt->execute([$project_id]);
$totalLabour = $stmt->fetch()['total'] ?? 0;
?>

<h4 class="mb-2">Labour – <?= htmlspecialchars($project['project_name']) ?></h4>

<div class="mb-3">
    <strong>Total Labour Cost:</strong> ₹<?= number_format($totalLabour, 2) ?>
</div>

<a href="labour_add.php?project_id=<?= $project_id ?>" class="btn btn-primary btn-sm mb-3">
    + Add Labour
</a>

<?php if (!$labours): ?>
    <p>No labour added yet.</p>
<?php endif; ?>

<div class="row">
<?php foreach ($labours as $l): ?>
    <div class="col-md-4 col-12 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6><?= htmlspecialchars($l['labour_name']) ?></h6>
                <small>Work: <?= $l['work_type'] ?></small><br>
                <small>Type: <?= $l['charge_type'] ?></small><br>
                <small>Rate: ₹<?= $l['rate'] ?></small><br>
                <small>Days: <?= $l['working_days'] ?></small><br>
                <strong>Total: ₹<?= number_format($l['total_amount'],2) ?></strong><br><br>

                <a href="labour_edit.php?id=<?= $l['id'] ?>&project_id=<?= $project_id ?>"
                   class="btn btn-sm btn-warning">Edit</a>

                <a href="labour_delete.php?id=<?= $l['id'] ?>&project_id=<?= $project_id ?>"
                   class="btn btn-sm btn-danger"
                   onclick="return confirm('Delete this labour entry?')">
                   Delete
                </a>
            </div>
        </div>
    </div>
<?php endforeach; ?>
</div>

<?php include "app/views/footer.php"; ?>
