<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$stmt = $pdo->query("
SELECT i.*, p.project_name, c.name AS client_name
FROM invoices i
JOIN projects p ON i.project_id = p.id
JOIN clients c ON p.client_id = c.id
ORDER BY i.id DESC
");
$invoices = $stmt->fetchAll();
?>

<!-- PAGE HEADER -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">All Invoices</h4>

    <!-- Add Invoice Button -->
   <a href="invoice_create.php" class="btn btn-primary btn-sm">
    + Add Invoice
</a>

</div>

<?php if (!$invoices): ?>
    <p>No invoices found.</p>
<?php endif; ?>

<div class="row">
<?php foreach ($invoices as $i): ?>
    <div class="col-md-4 col-12 mb-3">
        <div class="card shadow-sm position-relative">

            <!-- DOWNLOAD ICON -->
            <a href=""
               class="position-absolute top-0 end-0 p-2 text-dark"
               title="Download Invoice">
                ⬇️
            </a>

            <div class="card-body">
                <h6 class="mb-1"><?= $i['invoice_number'] ?></h6>

                <small class="text-muted">
                    Client: <?= htmlspecialchars($i['client_name']) ?>
                </small><br>

                <small>
                    Project: <?= htmlspecialchars($i['project_name']) ?>
                </small>

                <hr class="my-2">

                <div class="d-flex justify-content-between align-items-center">
                    <strong>₹<?= number_format($i['grand_total'],2) ?></strong>

                    <?php if ($i['status'] === 'Paid'): ?>
                        <span class="badge bg-success">Paid</span>
                    <?php else: ?>
                        <span class="badge bg-warning text-dark">Pending</span>
                    <?php endif; ?>
                </div>

                <div class="mt-2">
                    <a href="invoice_view.php?id=<?= $i['id'] ?>" class="btn btn-sm btn-outline-primary">
                        View
                    </a>

                    <?php if ($i['status'] === 'Pending'): ?>
                        <a href="invoice_mark_paid.php?id=<?= $i['id'] ?>"
                           class="btn btn-sm btn-outline-success">
                            Mark Paid
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; ?>
</div>

<?php include "app/views/footer.php"; ?>
