<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$project_id = $_GET['project_id'] ?? null;
if (!$project_id) die("Project not selected");

// Fetch project
$stmt = $pdo->prepare("SELECT project_name FROM projects WHERE id=?");
$stmt->execute([$project_id]);
$project = $stmt->fetch();

// Fetch invoices
$stmt = $pdo->prepare("SELECT * FROM invoices WHERE project_id=? ORDER BY id DESC");
$stmt->execute([$project_id]);
$invoices = $stmt->fetchAll();
?>

<h4 class="mb-2">Invoices – <?= htmlspecialchars($project['project_name']) ?></h4>

<a href="invoice_add.php?project_id=<?= $project_id ?>" class="btn btn-primary btn-sm mb-3">
    + Generate Invoice
</a>

<?php if (!$invoices): ?>
    <p>No invoices generated yet.</p>
<?php endif; ?>

<div class="row">
<?php foreach ($invoices as $i): ?>
    <div class="col-md-4 col-12 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6>Invoice #<?= $i['invoice_number'] ?></h6>
                <small>Date: <?= $i['invoice_date'] ?></small><br>
                <strong>Total: ₹<?= number_format($i['grand_total'],2) ?></strong><br>
                <small>Status: <b><?= $i['status'] ?></b></small><br><br>

                <a href="invoice_view.php?id=<?= $i['id'] ?>" class="btn btn-sm btn-info">View</a>

                <?php if ($i['status'] === 'Pending'): ?>
                    <a href="invoice_mark_paid.php?id=<?= $i['id'] ?>&project_id=<?= $project_id ?>"
                       class="btn btn-sm btn-success">
                       Mark Paid
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endforeach; ?>
</div>

<?php include "app/views/footer.php"; ?>
