<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$id = $_GET['id'];

$stmt = $pdo->prepare("
SELECT i.*, p.project_name, c.name as client_name
FROM invoices i
JOIN projects p ON i.project_id=p.id
JOIN clients c ON p.client_id=c.id
WHERE i.id=?
");
$stmt->execute([$id]);
$inv = $stmt->fetch();
?>

<h4>Invoice #<?= $inv['invoice_number'] ?></h4>

<p><b>Client:</b> <?= $inv['client_name'] ?></p>
<p><b>Project:</b> <?= $inv['project_name'] ?></p>
<p><b>Date:</b> <?= $inv['invoice_date'] ?></p>

<hr>

<p>Material Total: ₹<?= number_format($inv['material_total'],2) ?></p>
<p>Labour Total: ₹<?= number_format($inv['labour_total'],2) ?></p>
<p>Extra Charges: ₹<?= number_format($inv['extra_charges'],2) ?></p>

<hr>

<h5>Grand Total: ₹<?= number_format($inv['grand_total'],2) ?></h5>

<a href="" class="btn btn-dark btn-sm">
    Download PDF
</a>

<?php include "app/views/footer.php"; ?>
