<?php
require_once "vendor/autoload.php";
require_once "app/config/db.php";

use Dompdf\Dompdf;

$id = $_GET['id'];

$stmt = $pdo->prepare("
SELECT i.*, p.project_name, c.name as client_name
FROM invoices i
JOIN projects p ON i.project_id=p.id
JOIN clients c ON p.client_id=c.id
WHERE i.id=?
");
$stmt->execute([$id]);
$inv = $stmt->fetch();

$html = "
<h2>Invoice #{$inv['invoice_number']}</h2>
<p>Client: {$inv['client_name']}</p>
<p>Project: {$inv['project_name']}</p>
<p>Date: {$inv['invoice_date']}</p>
<hr>
<p>Material: ₹{$inv['material_total']}</p>
<p>Labour: ₹{$inv['labour_total']}</p>
<p>Extra: ₹{$inv['extra_charges']}</p>
<hr>
<h3>Total: ₹{$inv['grand_total']}</h3>
";

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->render();
$dompdf->stream("invoice.pdf");
