<?php
session_start();
require_once "app/config/db.php";

// Basic auth check
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}

$id = $_GET['id'] ?? null;
$project_id = $_GET['project_id'] ?? null;

if (!$id || !$project_id) {
    die("Invalid request");
}

// Update invoice status
$stmt = $pdo->prepare(
    "UPDATE invoices SET status='Paid' WHERE id=?"
);
$stmt->execute([$id]);

// Redirect back to invoices list
header("Location: invoices.php?project_id=".$project_id);
exit;
