<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

/* Fetch clients */
$clients = $pdo->query("SELECT id, name FROM clients ORDER BY name")->fetchAll();

$selected_client = $_GET['client_id'] ?? null;
$projects = [];

if ($selected_client) {
    $stmt = $pdo->prepare("SELECT id, project_name FROM projects WHERE client_id=?");
    $stmt->execute([$selected_client]);
    $projects = $stmt->fetchAll();
}
?>

<h4 class="mb-3">Create Invoice</h4>

<!-- STEP 1: SELECT CLIENT -->
<form method="GET" class="card p-3 shadow-sm mb-3">
    <label class="mb-1"><b>Select Client</b></label>
    <select name="client_id" class="form-control" onchange="this.form.submit()" required>
        <option value="">-- Select Client --</option>
        <?php foreach ($clients as $c): ?>
            <option value="<?= $c['id'] ?>"
                <?= ($selected_client == $c['id']) ? 'selected' : '' ?>>
                <?= htmlspecialchars($c['name']) ?>
            </option>
        <?php endforeach; ?>
    </select>
</form>

<!-- STEP 2: SELECT PROJECT -->
<?php if ($selected_client && $projects): ?>
<form method="GET" action="invoice_add.php" class="card p-3 shadow-sm">
    <input type="hidden" name="client_id" value="<?= $selected_client ?>">

    <label class="mb-1"><b>Select Project</b></label>
    <select name="project_id" class="form-control" required>
        <option value="">-- Select Project --</option>
        <?php foreach ($projects as $p): ?>
            <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['project_name']) ?></option>
        <?php endforeach; ?>
    </select>

    <button class="btn btn-primary mt-3">Proceed</button>
</form>
<?php endif; ?>

<?php include "app/views/footer.php"; ?>
