<?php
session_start();
require_once "app/config/db.php";

/* =========================
   HANDLE POST FIRST (NO OUTPUT)
========================= */

$project_id = $_GET['project_id'] ?? null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Calculate material total
    $stmt = $pdo->prepare("SELECT SUM(cost) FROM materials WHERE project_id=?");
    $stmt->execute([$project_id]);
    $material_total = $stmt->fetchColumn() ?? 0;

    // Calculate labour total
    $stmt = $pdo->prepare("SELECT SUM(total_amount) FROM labour WHERE project_id=?");
    $stmt->execute([$project_id]);
    $labour_total = $stmt->fetchColumn() ?? 0;

    $extra = $_POST['extra_charges'] ?? 0;
    $grand = $material_total + $labour_total + $extra;
    $invoice_number = "INV-" . time();

    $stmt = $pdo->prepare(
        "INSERT INTO invoices
        (project_id, invoice_number, invoice_date, material_total, labour_total, extra_charges, grand_total)
        VALUES (?, ?, ?, ?, ?, ?, ?)"
    );

    $stmt->execute([
        $project_id,
        $invoice_number,
        date('Y-m-d'),
        $material_total,
        $labour_total,
        $extra,
        $grand
    ]);
 
    header("Location: invoices.php?project_id=".$project_id);
    exit;
}

/* =========================
   NOW SAFE TO LOAD UI
========================= */

include "app/views/header.php";

/* Calculate totals for display */
$stmt = $pdo->prepare("SELECT SUM(cost) FROM materials WHERE project_id=?");
$stmt->execute([$project_id]);
$material_total = $stmt->fetchColumn() ?? 0;

$stmt = $pdo->prepare("SELECT SUM(total_amount) FROM labour WHERE project_id=?");
$stmt->execute([$project_id]);
$labour_total = $stmt->fetchColumn() ?? 0;
?>

<h4 class="mb-3">Generate Invoice</h4>

<form method="POST" class="card p-3 shadow-sm">
    <p>Material Cost: <b>₹<?= number_format($material_total,2) ?></b></p>
    <p>Labour Cost: <b>₹<?= number_format($labour_total,2) ?></b></p>

    <input class="form-control mb-2" name="extra_charges" placeholder="Extra Charges" value="0">

    <button class="btn btn-success">Generate Invoice</button>
</form>

<?php include "app/views/footer.php"; ?>
