<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

/* Total projects */
$totalProjects = $pdo->query("SELECT COUNT(*) FROM projects")->fetchColumn();

/* Ongoing projects */
$ongoingProjects = $pdo->query(
    "SELECT COUNT(*) FROM projects WHERE status='In Progress'"
)->fetchColumn();

/* Material expense */
$materialExpense = $pdo->query(
    "SELECT SUM(cost) FROM materials"
)->fetchColumn() ?? 0;

/* Labour expense */
$labourExpense = $pdo->query(
    "SELECT SUM(total_amount) FROM labour"
)->fetchColumn() ?? 0;

/* Total expense */
$totalExpense = $materialExpense + $labourExpense;

/* Total income (paid invoices only) */
$totalIncome = $pdo->query(
    "SELECT SUM(grand_total) FROM invoices WHERE status='Paid'"
)->fetchColumn() ?? 0;

/* Total purchase (materials only) */
$totalPurchase = $pdo->query(
    "SELECT SUM(cost) FROM materials"
)->fetchColumn() ?? 0;


/* Profit / Loss */
$profit = $totalIncome - $totalExpense;
?>

<h4 class="mb-4">Dashboard</h4>

<div class="row">
    <div class="col-md-3 col-6 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6>Total Projects</h6>
                <h3><?= $totalProjects ?></h3>
            </div>
        </div>
    </div>

    <div class="col-md-3 col-6 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6>Ongoing Projects</h6>
                <h3><?= $ongoingProjects ?></h3>
            </div>
        </div>
    </div>

    <div class="col-md-3 col-6 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6>Total Expense</h6>
                <h3>₹<?= number_format($totalExpense,2) ?></h3>
            </div>
        </div>
    </div>

    <div class="col-md-3 col-6 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6>Total Income</h6>
                <h3>₹<?= number_format($totalIncome,2) ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="col-md-3 col-6 mb-3">
    <div class="card shadow-sm">
        <div class="card-body">
            <h6>Total Purchase</h6>
            <h3>₹<?= number_format($totalPurchase, 2) ?></h3>
        </div>
    </div>
</div>

<?php include "app/views/footer.php"; ?>
