<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$stmt = $pdo->query("SELECT * FROM clients ORDER BY id DESC");
$clients = $stmt->fetchAll();
?>

<h4 class="mb-3">Clients</h4>

<a href="client_add.php" class="btn btn-primary btn-sm mb-3">+ Add Client</a>

<?php if (!$clients): ?>
    <p>No clients found.</p>
<?php endif; ?>

<div class="row">
<?php foreach ($clients as $c): ?>
    <div class="col-md-4 col-12 mb-3">
        <div class="card shadow-sm">
            <div class="card-body">
                <h6><?= htmlspecialchars($c['name']) ?></h6>
                <small>📞 <?= $c['phone'] ?></small><br>
                <small>✉️ <?= $c['email'] ?></small><br><br>
                <a href="projects.php?client_id=<?= $c['id'] ?>" class="btn btn-sm btn-info">
    Projects
</a>

                <a href="client_edit.php?id=<?= $c['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                <a href="client_delete.php?id=<?= $c['id'] ?>"
                   class="btn btn-sm btn-danger"
                   onclick="return confirm('Delete this client?')">
                   Delete
                </a>
            </div>
        </div>
    </div>
<?php endforeach; ?>
</div>

<?php include "app/views/footer.php"; ?>
