<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

$id = $_GET['id'];

$stmt = $pdo->prepare("SELECT * FROM clients WHERE id = ?");
$stmt->execute([$id]);
$client = $stmt->fetch();

if (!$client) {
    echo "Client not found";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare(
        "UPDATE clients SET name=?, phone=?, email=?, address=? WHERE id=?"
    );
    $stmt->execute([
        $_POST['name'],
        $_POST['phone'],
        $_POST['email'],
        $_POST['address'],
        $id
    ]);

    header("Location: clients.php");
    exit;
}
?>

<h4 class="mb-3">Edit Client</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="name" value="<?= $client['name'] ?>" required>
    <input class="form-control mb-2" name="phone" value="<?= $client['phone'] ?>">
    <input class="form-control mb-2" name="email" value="<?= $client['email'] ?>">
    <textarea class="form-control mb-2" name="address"><?= $client['address'] ?></textarea>

    <button class="btn btn-primary">Update Client</button>
</form>

<?php include "app/views/footer.php"; ?>
