<?php
session_start();
require_once "app/config/db.php";
include "app/views/header.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare(
        "INSERT INTO clients (name, phone, email, address)
         VALUES (?, ?, ?, ?)"
    );
    $stmt->execute([
        $_POST['name'],
        $_POST['phone'],
        $_POST['email'],
        $_POST['address']
    ]);

    header("Location: clients.php");
    exit;
}
?>

<h4 class="mb-3">Add Client</h4>

<form method="POST" class="card p-3 shadow-sm">
    <input class="form-control mb-2" name="name" placeholder="Client Name" required>
    <input class="form-control mb-2" name="phone" placeholder="Phone">
    <input class="form-control mb-2" name="email" placeholder="Email">
    <textarea class="form-control mb-2" name="address" placeholder="Address"></textarea>

    <button class="btn btn-success">Save Client</button>
</form>

<?php include "app/views/footer.php"; ?>
