<?php
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Real Estate Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

 <style>
    body {
        background:#f4f6f9;
    }

   .sidebar {
    width:240px;
    position:fixed;
    top:0;
    left:0;
    height:100vh;
    background:#ffffff;
    padding:16px 12px;
    border-right:1px solid #e5e7eb;
    transition: all 0.3s ease;
    z-index:1000;
}

.sidebar.collapsed {
    width:80px;
}

/* App title */
.sidebar .app-title {
    font-size:18px;
    font-weight:700;
    color:#0d6efd;
    text-align:center;
    margin-bottom:20px;
}

/* Menu */
.sidebar a {
    display:flex;
    align-items:center;
    gap:12px;
    padding:12px 14px;
    margin-bottom:10px;
    border-radius:14px;
    text-decoration:none;
    color:#333;
    font-weight:500;
    border:1px solid #f0f0f0;
    transition: all 0.2s ease;
}

/* Icon */
.sidebar a i {
    font-size:18px;
    min-width:22px;
    text-align:center;
    color:#555;
}

/* Hover */
.sidebar a:hover {
    background:#f5f8ff;
    border-color:#dbe7ff;
}

/* Active */
.sidebar a.active {
    background:#eaf1ff;
    border-color:#0d6efd;
    color:#0d6efd;
    box-shadow: 0 4px 12px rgba(13,110,253,0.15);
}

.sidebar a.active i {
    color:#0d6efd;
}

/* Collapse behavior */
.sidebar.collapsed a span {
    display:none;
}

.sidebar.collapsed .app-title span {
    display:none;
}

/* Content shift */
.content {
    margin-left:240px;
    padding:20px;
    transition: all 0.3s ease;
}

.content.expanded {
    margin-left:80px;
}

@media (max-width:768px) {
    .sidebar {
        left:-240px;
        width:240px;
    }

    .sidebar.show {
        left:0;
    }

    .content {
        margin-left:0;
    }

    .sidebar.collapsed {
        width:240px; /* disable collapse on mobile */
    }
}


/* ===== Bottom Navigation (Mobile Only) ===== */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    height: 64px;
    background: #ffffff;
    border-top: 1px solid #ddd;
    display: flex;
    justify-content: space-around;
    align-items: center;
    z-index: 2000;
}

.bottom-nav a {
    flex: 1;
    text-align: center;
    color: #777;
    font-size: 12px;
    text-decoration: none;
}

.bottom-nav a i {
    display: block;
    font-size: 20px;
    margin-bottom: 3px;
}

.bottom-nav a.active {
    color: #0d6efd;
}

.bottom-nav a.active i {
    transform: translateY(-2px);
}

/* space for bottom nav */
@media (max-width:768px) {
    body {
        padding-bottom: 70px;
    }
}

/* hide bottom nav on desktop */
@media (min-width:769px) {
    .bottom-nav {
        display: none;
    }
}


 
.topbar {
	position: sticky;
	top: 0;
	z-index: 900;
	background: rgba(255,255,255,0.85);
	backdrop-filter: blur(8px);
	border-bottom: 1px solid #e5e7eb;
	padding: 10px 16px;
	display: flex;
	align-items: center;
	justify-content: space-between;
	margin-bottom: 20px;
	border: 1px solid #dcdcdf;
	border-radius: 10px;
}

/* Left section */
.topbar-left {
    display: flex;
    align-items: center;
    gap: 12px;
}

/* Menu button */
.menu-btn {
    width: 40px;
    height: 40px;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
    background: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
}

.menu-btn:hover {
    background: #f5f8ff;
    border-color: #dbe7ff;
}

.menu-btn i {
    font-size: 18px;
    color: #333;
}

/* Page title */
.page-title {
    font-size: 16px;
    font-weight: 600;
    color: #333;
}

/* Right section */
.topbar-right {
    display: flex;
    align-items: center;
    gap: 10px;
}

/* Avatar */
.avatar {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: linear-gradient(135deg, #0d6efd, #6610f2);
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 14px;
}


</style>

</head>
<body>

<?php
$current = basename($_SERVER['PHP_SELF']);
?>

<div class="sidebar" id="sidebar">
    <div class="app-title">
        🏗 <span>RealEstate</span>
    </div>

    <a href="dashboard.php" class="<?= $current=='dashboard.php'?'active':'' ?>">
        <i class="fa-solid fa-house"></i>
        <span>Dashboard</span>
    </a>

    <a href="clients.php" class="<?= $current=='clients.php'?'active':'' ?>">
        <i class="fa-solid fa-users"></i>
        <span>Clients</span>
    </a>

    <a href="projects_all.php" class="<?= $current=='projects_all.php'?'active':'' ?>">
        <i class="fa-solid fa-building"></i>
        <span>Projects</span>
    </a>

    <a href="works_all.php" class="<?= $current=='works_all.php'?'active':'' ?>">
        <i class="fa-solid fa-list-check"></i>
        <span>Works</span>
    </a>

    <a href="materials_all.php" class="<?= $current=='materials_all.php'?'active':'' ?>">
        <i class="fa-solid fa-cubes"></i>
        <span>Materials</span>
    </a>

    <a href="labour_all.php" class="<?= $current=='labour_all.php'?'active':'' ?>">
        <i class="fa-solid fa-helmet-safety"></i>
        <span>Labour</span>
    </a>

    <a href="invoices_all.php" class="<?= $current=='invoices_all.php'?'active':'' ?>">
        <i class="fa-solid fa-file-invoice"></i>
        <span>Invoices</span>
    </a>
 

    <a href="logout.php" style="margin-top:20px">
        <i class="fa-solid fa-right-from-bracket"></i>
        <span>Logout</span>
    </a>
</div>



<div class="content" id="content">
   <?php
$page = ucfirst(str_replace(
    ['.php','_'],
    ['',' '],
    basename($_SERVER['PHP_SELF'])
));
?>

<div class="topbar">
    <div class="topbar-left">
        <div class="menu-btn" onclick="toggleSidebar()">
            <i class="fa-solid fa-bars"></i>
        </div>

        <div class="page-title">
          Welcome, Admin
        </div>
    </div>

    <div class="topbar-right">
        <div class="avatar">
            <?= strtoupper(substr($_SESSION['admin_name'] ?? 'A', 0, 1)) ?>
        </div>
    </div>
</div>


